package gov.va.vinci.dart.json.builder;

import java.text.SimpleDateFormat;

import gov.va.vinci.dart.biz.Event;
import gov.va.vinci.dart.biz.EventSummary;
import gov.va.vinci.dart.json.EventView;

public class EventViewBuilder {
	public static final SimpleDateFormat DATE_TIME_SDF = new SimpleDateFormat("MM/dd/yyyy hh:mm aa");
	
	public EventView build(final Event event) {
		EventView result = new EventView();
		
		result.setDescription(event.getDescription());
		result.setPerson(event.getCreatedBy());  // TODO- return the user's full name, not their AD name
		result.setDateTime(DATE_TIME_SDF.format(event.getCreatedOn()));
		
		return result;
	}

	public EventView build(final EventSummary summary) {
		EventView result = new EventView();
		
		result.setDescription(summary.getDescription());
		result.setPerson(summary.getCreatedBy()); 
		result.setDateTime(DATE_TIME_SDF.format(summary.getCreatedOn()));
		
		return result;
	}

}
